package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait RulePublishStatus {
  def unwrap: software.amazon.awssdk.services.connect.model.RulePublishStatus
}
object RulePublishStatus {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.RulePublishStatus
  ): zio.aws.connect.model.RulePublishStatus = value match {
    case software.amazon.awssdk.services.connect.model.RulePublishStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.RulePublishStatus.DRAFT =>
      val r = DRAFT
      r
    case software.amazon.awssdk.services.connect.model.RulePublishStatus.PUBLISHED =>
      val r = PUBLISHED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.RulePublishStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.RulePublishStatus =
      software.amazon.awssdk.services.connect.model.RulePublishStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DRAFT extends zio.aws.connect.model.RulePublishStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.RulePublishStatus =
      software.amazon.awssdk.services.connect.model.RulePublishStatus.DRAFT
  }
  case object PUBLISHED extends zio.aws.connect.model.RulePublishStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.RulePublishStatus =
      software.amazon.awssdk.services.connect.model.RulePublishStatus.PUBLISHED
  }
}
