package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.connect.model.primitives.{Timestamp, ARN, RuleId, RuleName}
import scala.jdk.CollectionConverters._
final case class RuleSummary(
    name: RuleName,
    ruleId: RuleId,
    ruleArn: ARN,
    eventSourceName: zio.aws.connect.model.EventSourceName,
    publishStatus: zio.aws.connect.model.RulePublishStatus,
    actionSummaries: Iterable[zio.aws.connect.model.ActionSummary],
    createdTime: Timestamp,
    lastUpdatedTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RuleSummary = {
    import RuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RuleSummary
      .builder()
      .name(RuleName.unwrap(name): java.lang.String)
      .ruleId(RuleId.unwrap(ruleId): java.lang.String)
      .ruleArn(ARN.unwrap(ruleArn): java.lang.String)
      .eventSourceName(eventSourceName.unwrap)
      .publishStatus(publishStatus.unwrap)
      .actionSummaries(actionSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RuleSummary.ReadOnly =
    zio.aws.connect.model.RuleSummary.wrap(buildAwsValue())
}
object RuleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RuleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RuleSummary =
      zio.aws.connect.model.RuleSummary(
        name,
        ruleId,
        ruleArn,
        eventSourceName,
        publishStatus,
        actionSummaries.map { item =>
          item.asEditable
        },
        createdTime,
        lastUpdatedTime
      )
    def name: RuleName
    def ruleId: RuleId
    def ruleArn: ARN
    def eventSourceName: zio.aws.connect.model.EventSourceName
    def publishStatus: zio.aws.connect.model.RulePublishStatus
    def actionSummaries: List[zio.aws.connect.model.ActionSummary.ReadOnly]
    def createdTime: Timestamp
    def lastUpdatedTime: Timestamp
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getRuleId: ZIO[Any, Nothing, RuleId] = ZIO.succeed(ruleId)
    def getRuleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(ruleArn)
    def getEventSourceName
        : ZIO[Any, Nothing, zio.aws.connect.model.EventSourceName] =
      ZIO.succeed(eventSourceName)
    def getPublishStatus
        : ZIO[Any, Nothing, zio.aws.connect.model.RulePublishStatus] =
      ZIO.succeed(publishStatus)
    def getActionSummaries: ZIO[Any, Nothing, List[
      zio.aws.connect.model.ActionSummary.ReadOnly
    ]] = ZIO.succeed(actionSummaries)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RuleSummary
  ) extends zio.aws.connect.model.RuleSummary.ReadOnly {
    override val name: RuleName =
      zio.aws.connect.model.primitives.RuleName(impl.name())
    override val ruleId: RuleId =
      zio.aws.connect.model.primitives.RuleId(impl.ruleId())
    override val ruleArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.ruleArn())
    override val eventSourceName: zio.aws.connect.model.EventSourceName =
      zio.aws.connect.model.EventSourceName.wrap(impl.eventSourceName())
    override val publishStatus: zio.aws.connect.model.RulePublishStatus =
      zio.aws.connect.model.RulePublishStatus.wrap(impl.publishStatus())
    override val actionSummaries
        : List[zio.aws.connect.model.ActionSummary.ReadOnly] = impl
      .actionSummaries()
      .asScala
      .map { item =>
        zio.aws.connect.model.ActionSummary.wrap(item)
      }
      .toList
    override val createdTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.createdTime())
    override val lastUpdatedTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.lastUpdatedTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RuleSummary
  ): zio.aws.connect.model.RuleSummary.ReadOnly = new Wrapper(impl)
}
