package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.IntegrationAssociationId
import scala.jdk.CollectionConverters._
final case class RuleTriggerEventSource(
    eventSourceName: zio.aws.connect.model.EventSourceName,
    integrationAssociationId: Optional[IntegrationAssociationId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RuleTriggerEventSource = {
    import RuleTriggerEventSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RuleTriggerEventSource
      .builder()
      .eventSourceName(eventSourceName.unwrap)
      .optionallyWith(
        integrationAssociationId.map(value =>
          IntegrationAssociationId.unwrap(value): java.lang.String
        )
      )(_.integrationAssociationId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RuleTriggerEventSource.ReadOnly =
    zio.aws.connect.model.RuleTriggerEventSource.wrap(buildAwsValue())
}
object RuleTriggerEventSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RuleTriggerEventSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RuleTriggerEventSource =
      zio.aws.connect.model.RuleTriggerEventSource(
        eventSourceName,
        integrationAssociationId.map(value => value)
      )
    def eventSourceName: zio.aws.connect.model.EventSourceName
    def integrationAssociationId: Optional[IntegrationAssociationId]
    def getEventSourceName
        : ZIO[Any, Nothing, zio.aws.connect.model.EventSourceName] =
      ZIO.succeed(eventSourceName)
    def getIntegrationAssociationId
        : ZIO[Any, AwsError, IntegrationAssociationId] = AwsError
      .unwrapOptionField("integrationAssociationId", integrationAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RuleTriggerEventSource
  ) extends zio.aws.connect.model.RuleTriggerEventSource.ReadOnly {
    override val eventSourceName: zio.aws.connect.model.EventSourceName =
      zio.aws.connect.model.EventSourceName.wrap(impl.eventSourceName())
    override val integrationAssociationId: Optional[IntegrationAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationAssociationId())
        .map(value =>
          zio.aws.connect.model.primitives.IntegrationAssociationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RuleTriggerEventSource
  ): zio.aws.connect.model.RuleTriggerEventSource.ReadOnly = new Wrapper(impl)
}
