package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.LargeNextToken
import scala.jdk.CollectionConverters._
final case class SearchAvailablePhoneNumbersResponse(
    nextToken: Optional[LargeNextToken] = Optional.Absent,
    availableNumbersList: Optional[
      Iterable[zio.aws.connect.model.AvailableNumberSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse = {
    import SearchAvailablePhoneNumbersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => LargeNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        availableNumbersList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availableNumbersList)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.ReadOnly =
    zio.aws.connect.model.SearchAvailablePhoneNumbersResponse
      .wrap(buildAwsValue())
}
object SearchAvailablePhoneNumbersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchAvailablePhoneNumbersResponse =
      zio.aws.connect.model.SearchAvailablePhoneNumbersResponse(
        nextToken.map(value => value),
        availableNumbersList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[LargeNextToken]
    def availableNumbersList
        : Optional[List[zio.aws.connect.model.AvailableNumberSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, LargeNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAvailableNumbersList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.AvailableNumberSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("availableNumbersList", availableNumbersList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse
  ) extends zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.ReadOnly {
    override val nextToken: Optional[LargeNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.LargeNextToken(value))
    override val availableNumbersList: Optional[
      List[zio.aws.connect.model.AvailableNumberSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.availableNumbersList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.AvailableNumberSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse
  ): zio.aws.connect.model.SearchAvailablePhoneNumbersResponse.ReadOnly =
    new Wrapper(impl)
}
