package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  MaxResult100,
  NextToken2500,
  InstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchHoursOfOperationsRequest(
    instanceId: InstanceId,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent,
    searchFilter: Optional[zio.aws.connect.model.HoursOfOperationSearchFilter] =
      Optional.Absent,
    searchCriteria: Optional[
      zio.aws.connect.model.HoursOfOperationSearchCriteria
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest = {
    import SearchHoursOfOperationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(searchFilter.map(value => value.buildAwsValue()))(
        _.searchFilter
      )
      .optionallyWith(searchCriteria.map(value => value.buildAwsValue()))(
        _.searchCriteria
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SearchHoursOfOperationsRequest.ReadOnly =
    zio.aws.connect.model.SearchHoursOfOperationsRequest.wrap(buildAwsValue())
}
object SearchHoursOfOperationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchHoursOfOperationsRequest =
      zio.aws.connect.model.SearchHoursOfOperationsRequest(
        instanceId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        searchFilter.map(value => value.asEditable),
        searchCriteria.map(value => value.asEditable)
      )
    def instanceId: InstanceId
    def nextToken: Optional[NextToken2500]
    def maxResults: Optional[MaxResult100]
    def searchFilter
        : Optional[zio.aws.connect.model.HoursOfOperationSearchFilter.ReadOnly]
    def searchCriteria: Optional[
      zio.aws.connect.model.HoursOfOperationSearchCriteria.ReadOnly
    ]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSearchFilter: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HoursOfOperationSearchFilter.ReadOnly
    ] = AwsError.unwrapOptionField("searchFilter", searchFilter)
    def getSearchCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HoursOfOperationSearchCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("searchCriteria", searchCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest
  ) extends zio.aws.connect.model.SearchHoursOfOperationsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
    override val searchFilter: Optional[
      zio.aws.connect.model.HoursOfOperationSearchFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.searchFilter())
      .map(value =>
        zio.aws.connect.model.HoursOfOperationSearchFilter.wrap(value)
      )
    override val searchCriteria: Optional[
      zio.aws.connect.model.HoursOfOperationSearchCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.searchCriteria())
      .map(value =>
        zio.aws.connect.model.HoursOfOperationSearchCriteria.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest
  ): zio.aws.connect.model.SearchHoursOfOperationsRequest.ReadOnly =
    new Wrapper(impl)
}
