package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ApproximateTotalCount, NextToken2500}
import scala.jdk.CollectionConverters._
final case class SearchHoursOfOperationsResponse(
    hoursOfOperations: Optional[
      Iterable[zio.aws.connect.model.HoursOfOperation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    approximateTotalCount: Optional[ApproximateTotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse = {
    import SearchHoursOfOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse
      .builder()
      .optionallyWith(
        hoursOfOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hoursOfOperations)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        approximateTotalCount.map(value =>
          ApproximateTotalCount.unwrap(value): java.lang.Long
        )
      )(_.approximateTotalCount)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SearchHoursOfOperationsResponse.ReadOnly =
    zio.aws.connect.model.SearchHoursOfOperationsResponse.wrap(buildAwsValue())
}
object SearchHoursOfOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchHoursOfOperationsResponse =
      zio.aws.connect.model.SearchHoursOfOperationsResponse(
        hoursOfOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        approximateTotalCount.map(value => value)
      )
    def hoursOfOperations
        : Optional[List[zio.aws.connect.model.HoursOfOperation.ReadOnly]]
    def nextToken: Optional[NextToken2500]
    def approximateTotalCount: Optional[ApproximateTotalCount]
    def getHoursOfOperations: ZIO[Any, AwsError, List[
      zio.aws.connect.model.HoursOfOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("hoursOfOperations", hoursOfOperations)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getApproximateTotalCount: ZIO[Any, AwsError, ApproximateTotalCount] =
      AwsError.unwrapOptionField("approximateTotalCount", approximateTotalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse
  ) extends zio.aws.connect.model.SearchHoursOfOperationsResponse.ReadOnly {
    override val hoursOfOperations
        : Optional[List[zio.aws.connect.model.HoursOfOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hoursOfOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.HoursOfOperation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val approximateTotalCount: Optional[ApproximateTotalCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateTotalCount())
        .map(value =>
          zio.aws.connect.model.primitives.ApproximateTotalCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse
  ): zio.aws.connect.model.SearchHoursOfOperationsResponse.ReadOnly =
    new Wrapper(impl)
}
