package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ApproximateTotalCount, NextToken2500}
import scala.jdk.CollectionConverters._
final case class SearchPromptsResponse(
    prompts: Optional[Iterable[zio.aws.connect.model.Prompt]] = Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    approximateTotalCount: Optional[ApproximateTotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchPromptsResponse = {
    import SearchPromptsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchPromptsResponse
      .builder()
      .optionallyWith(
        prompts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prompts)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        approximateTotalCount.map(value =>
          ApproximateTotalCount.unwrap(value): java.lang.Long
        )
      )(_.approximateTotalCount)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchPromptsResponse.ReadOnly =
    zio.aws.connect.model.SearchPromptsResponse.wrap(buildAwsValue())
}
object SearchPromptsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchPromptsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchPromptsResponse =
      zio.aws.connect.model.SearchPromptsResponse(
        prompts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        approximateTotalCount.map(value => value)
      )
    def prompts: Optional[List[zio.aws.connect.model.Prompt.ReadOnly]]
    def nextToken: Optional[NextToken2500]
    def approximateTotalCount: Optional[ApproximateTotalCount]
    def getPrompts
        : ZIO[Any, AwsError, List[zio.aws.connect.model.Prompt.ReadOnly]] =
      AwsError.unwrapOptionField("prompts", prompts)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getApproximateTotalCount: ZIO[Any, AwsError, ApproximateTotalCount] =
      AwsError.unwrapOptionField("approximateTotalCount", approximateTotalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchPromptsResponse
  ) extends zio.aws.connect.model.SearchPromptsResponse.ReadOnly {
    override val prompts
        : Optional[List[zio.aws.connect.model.Prompt.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prompts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.Prompt.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val approximateTotalCount: Optional[ApproximateTotalCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateTotalCount())
        .map(value =>
          zio.aws.connect.model.primitives.ApproximateTotalCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchPromptsResponse
  ): zio.aws.connect.model.SearchPromptsResponse.ReadOnly = new Wrapper(impl)
}
