package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ApproximateTotalCount, NextToken2500}
import scala.jdk.CollectionConverters._
final case class SearchQuickConnectsResponse(
    quickConnects: Optional[Iterable[zio.aws.connect.model.QuickConnect]] =
      Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    approximateTotalCount: Optional[ApproximateTotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse = {
    import SearchQuickConnectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse
      .builder()
      .optionallyWith(
        quickConnects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.quickConnects)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        approximateTotalCount.map(value =>
          ApproximateTotalCount.unwrap(value): java.lang.Long
        )
      )(_.approximateTotalCount)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchQuickConnectsResponse.ReadOnly =
    zio.aws.connect.model.SearchQuickConnectsResponse.wrap(buildAwsValue())
}
object SearchQuickConnectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchQuickConnectsResponse =
      zio.aws.connect.model.SearchQuickConnectsResponse(
        quickConnects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        approximateTotalCount.map(value => value)
      )
    def quickConnects
        : Optional[List[zio.aws.connect.model.QuickConnect.ReadOnly]]
    def nextToken: Optional[NextToken2500]
    def approximateTotalCount: Optional[ApproximateTotalCount]
    def getQuickConnects: ZIO[Any, AwsError, List[
      zio.aws.connect.model.QuickConnect.ReadOnly
    ]] = AwsError.unwrapOptionField("quickConnects", quickConnects)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getApproximateTotalCount: ZIO[Any, AwsError, ApproximateTotalCount] =
      AwsError.unwrapOptionField("approximateTotalCount", approximateTotalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse
  ) extends zio.aws.connect.model.SearchQuickConnectsResponse.ReadOnly {
    override val quickConnects
        : Optional[List[zio.aws.connect.model.QuickConnect.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickConnects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.QuickConnect.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val approximateTotalCount: Optional[ApproximateTotalCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateTotalCount())
        .map(value =>
          zio.aws.connect.model.primitives.ApproximateTotalCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse
  ): zio.aws.connect.model.SearchQuickConnectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
