package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  MaxResult100,
  NextToken2500,
  InstanceIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchResourceTagsRequest(
    instanceId: InstanceIdOrArn,
    resourceTypes: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent,
    searchCriteria: Optional[zio.aws.connect.model.ResourceTagsSearchCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest = {
    import SearchResourceTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest
      .builder()
      .instanceId(InstanceIdOrArn.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(searchCriteria.map(value => value.buildAwsValue()))(
        _.searchCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchResourceTagsRequest.ReadOnly =
    zio.aws.connect.model.SearchResourceTagsRequest.wrap(buildAwsValue())
}
object SearchResourceTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchResourceTagsRequest =
      zio.aws.connect.model.SearchResourceTagsRequest(
        instanceId,
        resourceTypes.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        searchCriteria.map(value => value.asEditable)
      )
    def instanceId: InstanceIdOrArn
    def resourceTypes: Optional[List[String]]
    def nextToken: Optional[NextToken2500]
    def maxResults: Optional[MaxResult100]
    def searchCriteria
        : Optional[zio.aws.connect.model.ResourceTagsSearchCriteria.ReadOnly]
    def getInstanceId: ZIO[Any, Nothing, InstanceIdOrArn] =
      ZIO.succeed(instanceId)
    def getResourceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSearchCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.ResourceTagsSearchCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("searchCriteria", searchCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest
  ) extends zio.aws.connect.model.SearchResourceTagsRequest.ReadOnly {
    override val instanceId: InstanceIdOrArn =
      zio.aws.connect.model.primitives.InstanceIdOrArn(impl.instanceId())
    override val resourceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
    override val searchCriteria
        : Optional[zio.aws.connect.model.ResourceTagsSearchCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchCriteria())
        .map(value =>
          zio.aws.connect.model.ResourceTagsSearchCriteria.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest
  ): zio.aws.connect.model.SearchResourceTagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
