package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken2500
import scala.jdk.CollectionConverters._
final case class SearchResourceTagsResponse(
    tags: Optional[Iterable[zio.aws.connect.model.TagSet]] = Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse = {
    import SearchResourceTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchResourceTagsResponse.ReadOnly =
    zio.aws.connect.model.SearchResourceTagsResponse.wrap(buildAwsValue())
}
object SearchResourceTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchResourceTagsResponse =
      zio.aws.connect.model.SearchResourceTagsResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tags: Optional[List[zio.aws.connect.model.TagSet.ReadOnly]]
    def nextToken: Optional[NextToken2500]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.connect.model.TagSet.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse
  ) extends zio.aws.connect.model.SearchResourceTagsResponse.ReadOnly {
    override val tags: Optional[List[zio.aws.connect.model.TagSet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.TagSet.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse
  ): zio.aws.connect.model.SearchResourceTagsResponse.ReadOnly = new Wrapper(
    impl
  )
}
