package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ApproximateTotalCount, NextToken2500}
import scala.jdk.CollectionConverters._
final case class SearchSecurityProfilesResponse(
    securityProfiles: Optional[
      Iterable[zio.aws.connect.model.SecurityProfileSearchSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    approximateTotalCount: Optional[ApproximateTotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse = {
    import SearchSecurityProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse
      .builder()
      .optionallyWith(
        securityProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityProfiles)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        approximateTotalCount.map(value =>
          ApproximateTotalCount.unwrap(value): java.lang.Long
        )
      )(_.approximateTotalCount)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly =
    zio.aws.connect.model.SearchSecurityProfilesResponse.wrap(buildAwsValue())
}
object SearchSecurityProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchSecurityProfilesResponse =
      zio.aws.connect.model.SearchSecurityProfilesResponse(
        securityProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        approximateTotalCount.map(value => value)
      )
    def securityProfiles: Optional[
      List[zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken2500]
    def approximateTotalCount: Optional[ApproximateTotalCount]
    def getSecurityProfiles: ZIO[Any, AwsError, List[
      zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("securityProfiles", securityProfiles)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getApproximateTotalCount: ZIO[Any, AwsError, ApproximateTotalCount] =
      AwsError.unwrapOptionField("approximateTotalCount", approximateTotalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse
  ) extends zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly {
    override val securityProfiles: Optional[
      List[zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityProfiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.SecurityProfileSearchSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val approximateTotalCount: Optional[ApproximateTotalCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateTotalCount())
        .map(value =>
          zio.aws.connect.model.primitives.ApproximateTotalCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse
  ): zio.aws.connect.model.SearchSecurityProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
