package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  MaxResult100,
  NextToken2500,
  InstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchUsersRequest(
    instanceId: Optional[InstanceId] = Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent,
    searchFilter: Optional[zio.aws.connect.model.UserSearchFilter] =
      Optional.Absent,
    searchCriteria: Optional[zio.aws.connect.model.UserSearchCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchUsersRequest = {
    import SearchUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchUsersRequest
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(searchFilter.map(value => value.buildAwsValue()))(
        _.searchFilter
      )
      .optionallyWith(searchCriteria.map(value => value.buildAwsValue()))(
        _.searchCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchUsersRequest.ReadOnly =
    zio.aws.connect.model.SearchUsersRequest.wrap(buildAwsValue())
}
object SearchUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchUsersRequest =
      zio.aws.connect.model.SearchUsersRequest(
        instanceId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        searchFilter.map(value => value.asEditable),
        searchCriteria.map(value => value.asEditable)
      )
    def instanceId: Optional[InstanceId]
    def nextToken: Optional[NextToken2500]
    def maxResults: Optional[MaxResult100]
    def searchFilter: Optional[zio.aws.connect.model.UserSearchFilter.ReadOnly]
    def searchCriteria
        : Optional[zio.aws.connect.model.UserSearchCriteria.ReadOnly]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSearchFilter
        : ZIO[Any, AwsError, zio.aws.connect.model.UserSearchFilter.ReadOnly] =
      AwsError.unwrapOptionField("searchFilter", searchFilter)
    def getSearchCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.UserSearchCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("searchCriteria", searchCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchUsersRequest
  ) extends zio.aws.connect.model.SearchUsersRequest.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
    override val searchFilter
        : Optional[zio.aws.connect.model.UserSearchFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchFilter())
        .map(value => zio.aws.connect.model.UserSearchFilter.wrap(value))
    override val searchCriteria
        : Optional[zio.aws.connect.model.UserSearchCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchCriteria())
        .map(value => zio.aws.connect.model.UserSearchCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchUsersRequest
  ): zio.aws.connect.model.SearchUsersRequest.ReadOnly = new Wrapper(impl)
}
