package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ApproximateTotalCount, NextToken2500}
import scala.jdk.CollectionConverters._
final case class SearchUsersResponse(
    users: Optional[Iterable[zio.aws.connect.model.UserSearchSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    approximateTotalCount: Optional[ApproximateTotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchUsersResponse = {
    import SearchUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        approximateTotalCount.map(value =>
          ApproximateTotalCount.unwrap(value): java.lang.Long
        )
      )(_.approximateTotalCount)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchUsersResponse.ReadOnly =
    zio.aws.connect.model.SearchUsersResponse.wrap(buildAwsValue())
}
object SearchUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchUsersResponse =
      zio.aws.connect.model.SearchUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        approximateTotalCount.map(value => value)
      )
    def users: Optional[List[zio.aws.connect.model.UserSearchSummary.ReadOnly]]
    def nextToken: Optional[NextToken2500]
    def approximateTotalCount: Optional[ApproximateTotalCount]
    def getUsers: ZIO[Any, AwsError, List[
      zio.aws.connect.model.UserSearchSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getApproximateTotalCount: ZIO[Any, AwsError, ApproximateTotalCount] =
      AwsError.unwrapOptionField("approximateTotalCount", approximateTotalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchUsersResponse
  ) extends zio.aws.connect.model.SearchUsersResponse.ReadOnly {
    override val users
        : Optional[List[zio.aws.connect.model.UserSearchSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.UserSearchSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val approximateTotalCount: Optional[ApproximateTotalCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateTotalCount())
        .map(value =>
          zio.aws.connect.model.primitives.ApproximateTotalCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchUsersResponse
  ): zio.aws.connect.model.SearchUsersResponse.ReadOnly = new Wrapper(impl)
}
