package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.VocabularyNextToken
import scala.jdk.CollectionConverters._
final case class SearchVocabulariesResponse(
    vocabularySummaryList: Optional[
      Iterable[zio.aws.connect.model.VocabularySummary]
    ] = Optional.Absent,
    nextToken: Optional[VocabularyNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse = {
    import SearchVocabulariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse
      .builder()
      .optionallyWith(
        vocabularySummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vocabularySummaryList)
      .optionallyWith(
        nextToken.map(value =>
          VocabularyNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchVocabulariesResponse.ReadOnly =
    zio.aws.connect.model.SearchVocabulariesResponse.wrap(buildAwsValue())
}
object SearchVocabulariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchVocabulariesResponse =
      zio.aws.connect.model.SearchVocabulariesResponse(
        vocabularySummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vocabularySummaryList
        : Optional[List[zio.aws.connect.model.VocabularySummary.ReadOnly]]
    def nextToken: Optional[VocabularyNextToken]
    def getVocabularySummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.VocabularySummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("vocabularySummaryList", vocabularySummaryList)
    def getNextToken: ZIO[Any, AwsError, VocabularyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse
  ) extends zio.aws.connect.model.SearchVocabulariesResponse.ReadOnly {
    override val vocabularySummaryList
        : Optional[List[zio.aws.connect.model.VocabularySummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularySummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.VocabularySummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[VocabularyNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.connect.model.primitives.VocabularyNextToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse
  ): zio.aws.connect.model.SearchVocabulariesResponse.ReadOnly = new Wrapper(
    impl
  )
}
