package zio.aws.connect.model
import zio.aws.connect.model.primitives.{Timestamp, PEM, AssociationId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SecurityKey(
    associationId: Optional[AssociationId] = Optional.Absent,
    key: Optional[PEM] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SecurityKey = {
    import SecurityKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SecurityKey
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(key.map(value => PEM.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SecurityKey.ReadOnly =
    zio.aws.connect.model.SecurityKey.wrap(buildAwsValue())
}
object SecurityKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SecurityKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SecurityKey =
      zio.aws.connect.model.SecurityKey(
        associationId.map(value => value),
        key.map(value => value),
        creationTime.map(value => value)
      )
    def associationId: Optional[AssociationId]
    def key: Optional[PEM]
    def creationTime: Optional[Timestamp]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getKey: ZIO[Any, AwsError, PEM] = AwsError.unwrapOptionField("key", key)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SecurityKey
  ) extends zio.aws.connect.model.SecurityKey.ReadOnly {
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.connect.model.primitives.AssociationId(value))
    override val key: Optional[PEM] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.connect.model.primitives.PEM(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SecurityKey
  ): zio.aws.connect.model.SecurityKey.ReadOnly = new Wrapper(impl)
}
