package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  SecurityProfilePolicyValue,
  SecurityProfilePolicyKey,
  SecurityProfileDescription,
  InstanceId,
  TagValue,
  SecurityProfileName,
  TagRestrictedResourceName,
  ARN,
  TagKey,
  SecurityProfileId
}
import scala.jdk.CollectionConverters._
final case class SecurityProfile(
    id: Optional[SecurityProfileId] = Optional.Absent,
    organizationResourceId: Optional[InstanceId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    securityProfileName: Optional[SecurityProfileName] = Optional.Absent,
    description: Optional[SecurityProfileDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    allowedAccessControlTags: Optional[
      Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]
    ] = Optional.Absent,
    tagRestrictedResources: Optional[Iterable[TagRestrictedResourceName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SecurityProfile = {
    import SecurityProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SecurityProfile
      .builder()
      .optionallyWith(
        id.map(value => SecurityProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        organizationResourceId.map(value =>
          InstanceId.unwrap(value): java.lang.String
        )
      )(_.organizationResourceId)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        description.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        allowedAccessControlTags.map(value =>
          value
            .map({ case (key, value) =>
              (SecurityProfilePolicyKey
                .unwrap(key): java.lang.String) -> (SecurityProfilePolicyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.allowedAccessControlTags)
      .optionallyWith(
        tagRestrictedResources.map(value =>
          value.map { item =>
            TagRestrictedResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagRestrictedResources)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SecurityProfile.ReadOnly =
    zio.aws.connect.model.SecurityProfile.wrap(buildAwsValue())
}
object SecurityProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SecurityProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SecurityProfile =
      zio.aws.connect.model.SecurityProfile(
        id.map(value => value),
        organizationResourceId.map(value => value),
        arn.map(value => value),
        securityProfileName.map(value => value),
        description.map(value => value),
        tags.map(value => value),
        allowedAccessControlTags.map(value => value),
        tagRestrictedResources.map(value => value)
      )
    def id: Optional[SecurityProfileId]
    def organizationResourceId: Optional[InstanceId]
    def arn: Optional[ARN]
    def securityProfileName: Optional[SecurityProfileName]
    def description: Optional[SecurityProfileDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def allowedAccessControlTags
        : Optional[Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]]
    def tagRestrictedResources: Optional[List[TagRestrictedResourceName]]
    def getId: ZIO[Any, AwsError, SecurityProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getOrganizationResourceId: ZIO[Any, AwsError, InstanceId] = AwsError
      .unwrapOptionField("organizationResourceId", organizationResourceId)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getDescription: ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAllowedAccessControlTags: ZIO[Any, AwsError, Map[
      SecurityProfilePolicyKey,
      SecurityProfilePolicyValue
    ]] = AwsError.unwrapOptionField(
      "allowedAccessControlTags",
      allowedAccessControlTags
    )
    def getTagRestrictedResources
        : ZIO[Any, AwsError, List[TagRestrictedResourceName]] = AwsError
      .unwrapOptionField("tagRestrictedResources", tagRestrictedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfile
  ) extends zio.aws.connect.model.SecurityProfile.ReadOnly {
    override val id: Optional[SecurityProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.SecurityProfileId(value))
    override val organizationResourceId: Optional[InstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationResourceId())
        .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val securityProfileName: Optional[SecurityProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileName())
        .map(value =>
          zio.aws.connect.model.primitives.SecurityProfileName(value)
        )
    override val description: Optional[SecurityProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.SecurityProfileDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val allowedAccessControlTags
        : Optional[Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedAccessControlTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.SecurityProfilePolicyKey(
                key
              ) -> zio.aws.connect.model.primitives
                .SecurityProfilePolicyValue(value)
            })
            .toMap
        )
    override val tagRestrictedResources
        : Optional[List[TagRestrictedResourceName]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagRestrictedResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.TagRestrictedResourceName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfile
  ): zio.aws.connect.model.SecurityProfile.ReadOnly = new Wrapper(impl)
}
