package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityProfileSearchCriteria(
    orConditions: Optional[
      Iterable[zio.aws.connect.model.SecurityProfileSearchCriteria]
    ] = Optional.Absent,
    andConditions: Optional[
      Iterable[zio.aws.connect.model.SecurityProfileSearchCriteria]
    ] = Optional.Absent,
    stringCondition: Optional[zio.aws.connect.model.StringCondition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SecurityProfileSearchCriteria = {
    import SecurityProfileSearchCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SecurityProfileSearchCriteria
      .builder()
      .optionallyWith(
        orConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orConditions)
      .optionallyWith(
        andConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.andConditions)
      .optionallyWith(stringCondition.map(value => value.buildAwsValue()))(
        _.stringCondition
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly =
    zio.aws.connect.model.SecurityProfileSearchCriteria.wrap(buildAwsValue())
}
object SecurityProfileSearchCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SecurityProfileSearchCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SecurityProfileSearchCriteria =
      zio.aws.connect.model.SecurityProfileSearchCriteria(
        orConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        andConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stringCondition.map(value => value.asEditable)
      )
    def orConditions: Optional[
      List[zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly]
    ]
    def andConditions: Optional[
      List[zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly]
    ]
    def stringCondition
        : Optional[zio.aws.connect.model.StringCondition.ReadOnly]
    def getOrConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly
    ]] = AwsError.unwrapOptionField("orConditions", orConditions)
    def getAndConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly
    ]] = AwsError.unwrapOptionField("andConditions", andConditions)
    def getStringCondition
        : ZIO[Any, AwsError, zio.aws.connect.model.StringCondition.ReadOnly] =
      AwsError.unwrapOptionField("stringCondition", stringCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfileSearchCriteria
  ) extends zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly {
    override val orConditions: Optional[
      List[zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.orConditions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.SecurityProfileSearchCriteria.wrap(item)
        }.toList
      )
    override val andConditions: Optional[
      List[zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.andConditions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.SecurityProfileSearchCriteria.wrap(item)
        }.toList
      )
    override val stringCondition
        : Optional[zio.aws.connect.model.StringCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringCondition())
        .map(value => zio.aws.connect.model.StringCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfileSearchCriteria
  ): zio.aws.connect.model.SecurityProfileSearchCriteria.ReadOnly = new Wrapper(
    impl
  )
}
