package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{Content, Subject}
import scala.jdk.CollectionConverters._
final case class SendNotificationActionDefinition(
    deliveryMethod: zio.aws.connect.model.NotificationDeliveryType,
    subject: Optional[Subject] = Optional.Absent,
    content: Content,
    contentType: zio.aws.connect.model.NotificationContentType,
    recipient: zio.aws.connect.model.NotificationRecipientType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SendNotificationActionDefinition = {
    import SendNotificationActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SendNotificationActionDefinition
      .builder()
      .deliveryMethod(deliveryMethod.unwrap)
      .optionallyWith(
        subject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.subject)
      .content(Content.unwrap(content): java.lang.String)
      .contentType(contentType.unwrap)
      .recipient(recipient.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SendNotificationActionDefinition.ReadOnly =
    zio.aws.connect.model.SendNotificationActionDefinition.wrap(buildAwsValue())
}
object SendNotificationActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SendNotificationActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SendNotificationActionDefinition =
      zio.aws.connect.model.SendNotificationActionDefinition(
        deliveryMethod,
        subject.map(value => value),
        content,
        contentType,
        recipient.asEditable
      )
    def deliveryMethod: zio.aws.connect.model.NotificationDeliveryType
    def subject: Optional[Subject]
    def content: Content
    def contentType: zio.aws.connect.model.NotificationContentType
    def recipient: zio.aws.connect.model.NotificationRecipientType.ReadOnly
    def getDeliveryMethod
        : ZIO[Any, Nothing, zio.aws.connect.model.NotificationDeliveryType] =
      ZIO.succeed(deliveryMethod)
    def getSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("subject", subject)
    def getContent: ZIO[Any, Nothing, Content] = ZIO.succeed(content)
    def getContentType
        : ZIO[Any, Nothing, zio.aws.connect.model.NotificationContentType] =
      ZIO.succeed(contentType)
    def getRecipient: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.NotificationRecipientType.ReadOnly
    ] = ZIO.succeed(recipient)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SendNotificationActionDefinition
  ) extends zio.aws.connect.model.SendNotificationActionDefinition.ReadOnly {
    override val deliveryMethod
        : zio.aws.connect.model.NotificationDeliveryType =
      zio.aws.connect.model.NotificationDeliveryType.wrap(impl.deliveryMethod())
    override val subject: Optional[Subject] = zio.aws.core.internal
      .optionalFromNullable(impl.subject())
      .map(value => zio.aws.connect.model.primitives.Subject(value))
    override val content: Content =
      zio.aws.connect.model.primitives.Content(impl.content())
    override val contentType: zio.aws.connect.model.NotificationContentType =
      zio.aws.connect.model.NotificationContentType.wrap(impl.contentType())
    override val recipient
        : zio.aws.connect.model.NotificationRecipientType.ReadOnly =
      zio.aws.connect.model.NotificationRecipientType.wrap(impl.recipient())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SendNotificationActionDefinition
  ): zio.aws.connect.model.SendNotificationActionDefinition.ReadOnly =
    new Wrapper(impl)
}
