package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SignInConfig(
    distributions: Iterable[zio.aws.connect.model.SignInDistribution]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SignInConfig = {
    import SignInConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SignInConfig
      .builder()
      .distributions(distributions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SignInConfig.ReadOnly =
    zio.aws.connect.model.SignInConfig.wrap(buildAwsValue())
}
object SignInConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SignInConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SignInConfig =
      zio.aws.connect.model.SignInConfig(distributions.map { item =>
        item.asEditable
      })
    def distributions: List[zio.aws.connect.model.SignInDistribution.ReadOnly]
    def getDistributions: ZIO[Any, Nothing, List[
      zio.aws.connect.model.SignInDistribution.ReadOnly
    ]] = ZIO.succeed(distributions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SignInConfig
  ) extends zio.aws.connect.model.SignInConfig.ReadOnly {
    override val distributions
        : List[zio.aws.connect.model.SignInDistribution.ReadOnly] = impl
      .distributions()
      .asScala
      .map { item =>
        zio.aws.connect.model.SignInDistribution.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SignInConfig
  ): zio.aws.connect.model.SignInConfig.ReadOnly = new Wrapper(impl)
}
