package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.AwsRegion
import scala.jdk.CollectionConverters._
final case class SignInDistribution(region: AwsRegion, enabled: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SignInDistribution = {
    import SignInDistribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SignInDistribution
      .builder()
      .region(AwsRegion.unwrap(region): java.lang.String)
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SignInDistribution.ReadOnly =
    zio.aws.connect.model.SignInDistribution.wrap(buildAwsValue())
}
object SignInDistribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SignInDistribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SignInDistribution =
      zio.aws.connect.model.SignInDistribution(region, enabled)
    def region: AwsRegion
    def enabled: Boolean
    def getRegion: ZIO[Any, Nothing, AwsRegion] = ZIO.succeed(region)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SignInDistribution
  ) extends zio.aws.connect.model.SignInDistribution.ReadOnly {
    override val region: AwsRegion =
      zio.aws.connect.model.primitives.AwsRegion(impl.region())
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SignInDistribution
  ): zio.aws.connect.model.SignInDistribution.ReadOnly = new Wrapper(impl)
}
