package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  ReferenceId,
  SingleSelectQuestionRuleCategoryAutomationLabel
}
import scala.jdk.CollectionConverters._
final case class SingleSelectQuestionRuleCategoryAutomation(
    category: SingleSelectQuestionRuleCategoryAutomationLabel,
    condition: zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomationCondition,
    optionRefId: ReferenceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SingleSelectQuestionRuleCategoryAutomation = {
    import SingleSelectQuestionRuleCategoryAutomation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SingleSelectQuestionRuleCategoryAutomation
      .builder()
      .category(
        SingleSelectQuestionRuleCategoryAutomationLabel.unwrap(
          category
        ): java.lang.String
      )
      .condition(condition.unwrap)
      .optionRefId(ReferenceId.unwrap(optionRefId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation.ReadOnly =
    zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation
      .wrap(buildAwsValue())
}
object SingleSelectQuestionRuleCategoryAutomation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SingleSelectQuestionRuleCategoryAutomation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation =
      zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation(
        category,
        condition,
        optionRefId
      )
    def category: SingleSelectQuestionRuleCategoryAutomationLabel
    def condition: zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomationCondition
    def optionRefId: ReferenceId
    def getCategory
        : ZIO[Any, Nothing, SingleSelectQuestionRuleCategoryAutomationLabel] =
      ZIO.succeed(category)
    def getCondition: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomationCondition
    ] = ZIO.succeed(condition)
    def getOptionRefId: ZIO[Any, Nothing, ReferenceId] =
      ZIO.succeed(optionRefId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SingleSelectQuestionRuleCategoryAutomation
  ) extends zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation.ReadOnly {
    override val category: SingleSelectQuestionRuleCategoryAutomationLabel =
      zio.aws.connect.model.primitives
        .SingleSelectQuestionRuleCategoryAutomationLabel(impl.category())
    override val condition
        : zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomationCondition =
      zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomationCondition
        .wrap(impl.condition())
    override val optionRefId: ReferenceId =
      zio.aws.connect.model.primitives.ReferenceId(impl.optionRefId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SingleSelectQuestionRuleCategoryAutomation
  ): zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation.ReadOnly =
    new Wrapper(impl)
}
