package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.connect.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.SortOrder
  ): zio.aws.connect.model.SortOrder = value match {
    case software.amazon.awssdk.services.connect.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.SortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.connect.model.SortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.SortOrder =
      software.amazon.awssdk.services.connect.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.connect.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.SortOrder =
      software.amazon.awssdk.services.connect.model.SortOrder.ASCENDING
  }
  case object DESCENDING extends zio.aws.connect.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.SortOrder =
      software.amazon.awssdk.services.connect.model.SortOrder.DESCENDING
  }
}
