package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  AttributeName,
  SupportedMessagingContentType,
  InstanceId,
  ChatDurationInMinutes,
  ContactId,
  ClientToken,
  ContactFlowId,
  AttributeValue
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartChatContactRequest(
    instanceId: InstanceId,
    contactFlowId: ContactFlowId,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    participantDetails: zio.aws.connect.model.ParticipantDetails,
    initialMessage: Optional[zio.aws.connect.model.ChatMessage] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    chatDurationInMinutes: Optional[ChatDurationInMinutes] = Optional.Absent,
    supportedMessagingContentTypes: Optional[
      Iterable[SupportedMessagingContentType]
    ] = Optional.Absent,
    persistentChat: Optional[zio.aws.connect.model.PersistentChat] =
      Optional.Absent,
    relatedContactId: Optional[ContactId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartChatContactRequest = {
    import StartChatContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartChatContactRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .participantDetails(participantDetails.buildAwsValue())
      .optionallyWith(initialMessage.map(value => value.buildAwsValue()))(
        _.initialMessage
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        chatDurationInMinutes.map(value =>
          ChatDurationInMinutes.unwrap(value): Integer
        )
      )(_.chatDurationInMinutes)
      .optionallyWith(
        supportedMessagingContentTypes.map(value =>
          value.map { item =>
            SupportedMessagingContentType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedMessagingContentTypes)
      .optionallyWith(persistentChat.map(value => value.buildAwsValue()))(
        _.persistentChat
      )
      .optionallyWith(
        relatedContactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.relatedContactId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartChatContactRequest.ReadOnly =
    zio.aws.connect.model.StartChatContactRequest.wrap(buildAwsValue())
}
object StartChatContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartChatContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartChatContactRequest =
      zio.aws.connect.model.StartChatContactRequest(
        instanceId,
        contactFlowId,
        attributes.map(value => value),
        participantDetails.asEditable,
        initialMessage.map(value => value.asEditable),
        clientToken.map(value => value),
        chatDurationInMinutes.map(value => value),
        supportedMessagingContentTypes.map(value => value),
        persistentChat.map(value => value.asEditable),
        relatedContactId.map(value => value)
      )
    def instanceId: InstanceId
    def contactFlowId: ContactFlowId
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def participantDetails: zio.aws.connect.model.ParticipantDetails.ReadOnly
    def initialMessage: Optional[zio.aws.connect.model.ChatMessage.ReadOnly]
    def clientToken: Optional[ClientToken]
    def chatDurationInMinutes: Optional[ChatDurationInMinutes]
    def supportedMessagingContentTypes
        : Optional[List[SupportedMessagingContentType]]
    def persistentChat: Optional[zio.aws.connect.model.PersistentChat.ReadOnly]
    def relatedContactId: Optional[ContactId]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getParticipantDetails
        : ZIO[Any, Nothing, zio.aws.connect.model.ParticipantDetails.ReadOnly] =
      ZIO.succeed(participantDetails)
    def getInitialMessage
        : ZIO[Any, AwsError, zio.aws.connect.model.ChatMessage.ReadOnly] =
      AwsError.unwrapOptionField("initialMessage", initialMessage)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getChatDurationInMinutes: ZIO[Any, AwsError, ChatDurationInMinutes] =
      AwsError.unwrapOptionField("chatDurationInMinutes", chatDurationInMinutes)
    def getSupportedMessagingContentTypes
        : ZIO[Any, AwsError, List[SupportedMessagingContentType]] =
      AwsError.unwrapOptionField(
        "supportedMessagingContentTypes",
        supportedMessagingContentTypes
      )
    def getPersistentChat
        : ZIO[Any, AwsError, zio.aws.connect.model.PersistentChat.ReadOnly] =
      AwsError.unwrapOptionField("persistentChat", persistentChat)
    def getRelatedContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("relatedContactId", relatedContactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartChatContactRequest
  ) extends zio.aws.connect.model.StartChatContactRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.AttributeName(
                key
              ) -> zio.aws.connect.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val participantDetails
        : zio.aws.connect.model.ParticipantDetails.ReadOnly =
      zio.aws.connect.model.ParticipantDetails.wrap(impl.participantDetails())
    override val initialMessage
        : Optional[zio.aws.connect.model.ChatMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialMessage())
        .map(value => zio.aws.connect.model.ChatMessage.wrap(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val chatDurationInMinutes: Optional[ChatDurationInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.chatDurationInMinutes())
        .map(value =>
          zio.aws.connect.model.primitives.ChatDurationInMinutes(value)
        )
    override val supportedMessagingContentTypes
        : Optional[List[SupportedMessagingContentType]] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedMessagingContentTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.SupportedMessagingContentType(item)
        }.toList
      )
    override val persistentChat
        : Optional[zio.aws.connect.model.PersistentChat.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.persistentChat())
        .map(value => zio.aws.connect.model.PersistentChat.wrap(value))
    override val relatedContactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.relatedContactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartChatContactRequest
  ): zio.aws.connect.model.StartChatContactRequest.ReadOnly = new Wrapper(impl)
}
