package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ClientToken,
  ResourceId,
  ContactId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class StartContactEvaluationRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    evaluationFormId: ResourceId,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartContactEvaluationRequest = {
    import StartContactEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartContactEvaluationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartContactEvaluationRequest.ReadOnly =
    zio.aws.connect.model.StartContactEvaluationRequest.wrap(buildAwsValue())
}
object StartContactEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartContactEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartContactEvaluationRequest =
      zio.aws.connect.model.StartContactEvaluationRequest(
        instanceId,
        contactId,
        evaluationFormId,
        clientToken.map(value => value)
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def evaluationFormId: ResourceId
    def clientToken: Optional[ClientToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartContactEvaluationRequest
  ) extends zio.aws.connect.model.StartContactEvaluationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartContactEvaluationRequest
  ): zio.aws.connect.model.StartContactEvaluationRequest.ReadOnly = new Wrapper(
    impl
  )
}
