package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ARN, ResourceId}
import scala.jdk.CollectionConverters._
final case class StartContactEvaluationResponse(
    evaluationId: ResourceId,
    evaluationArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartContactEvaluationResponse = {
    import StartContactEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartContactEvaluationResponse
      .builder()
      .evaluationId(ResourceId.unwrap(evaluationId): java.lang.String)
      .evaluationArn(ARN.unwrap(evaluationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.StartContactEvaluationResponse.ReadOnly =
    zio.aws.connect.model.StartContactEvaluationResponse.wrap(buildAwsValue())
}
object StartContactEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartContactEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartContactEvaluationResponse =
      zio.aws.connect.model
        .StartContactEvaluationResponse(evaluationId, evaluationArn)
    def evaluationId: ResourceId
    def evaluationArn: ARN
    def getEvaluationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationId)
    def getEvaluationArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(evaluationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartContactEvaluationResponse
  ) extends zio.aws.connect.model.StartContactEvaluationResponse.ReadOnly {
    override val evaluationId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationId())
    override val evaluationArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartContactEvaluationResponse
  ): zio.aws.connect.model.StartContactEvaluationResponse.ReadOnly =
    new Wrapper(impl)
}
