package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ClientToken, ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class StartContactStreamingRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    chatStreamingConfiguration: zio.aws.connect.model.ChatStreamingConfiguration,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartContactStreamingRequest = {
    import StartContactStreamingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartContactStreamingRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .chatStreamingConfiguration(chatStreamingConfiguration.buildAwsValue())
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartContactStreamingRequest.ReadOnly =
    zio.aws.connect.model.StartContactStreamingRequest.wrap(buildAwsValue())
}
object StartContactStreamingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartContactStreamingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartContactStreamingRequest =
      zio.aws.connect.model.StartContactStreamingRequest(
        instanceId,
        contactId,
        chatStreamingConfiguration.asEditable,
        clientToken
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def chatStreamingConfiguration
        : zio.aws.connect.model.ChatStreamingConfiguration.ReadOnly
    def clientToken: ClientToken
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getChatStreamingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.ChatStreamingConfiguration.ReadOnly
    ] = ZIO.succeed(chatStreamingConfiguration)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartContactStreamingRequest
  ) extends zio.aws.connect.model.StartContactStreamingRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val chatStreamingConfiguration
        : zio.aws.connect.model.ChatStreamingConfiguration.ReadOnly =
      zio.aws.connect.model.ChatStreamingConfiguration
        .wrap(impl.chatStreamingConfiguration())
    override val clientToken: ClientToken =
      zio.aws.connect.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartContactStreamingRequest
  ): zio.aws.connect.model.StartContactStreamingRequest.ReadOnly = new Wrapper(
    impl
  )
}
