package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ContactId
import scala.jdk.CollectionConverters._
final case class StartOutboundVoiceContactResponse(
    contactId: Optional[ContactId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse = {
    import StartOutboundVoiceContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse
      .builder()
      .optionallyWith(
        contactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.contactId)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.StartOutboundVoiceContactResponse.ReadOnly =
    zio.aws.connect.model.StartOutboundVoiceContactResponse
      .wrap(buildAwsValue())
}
object StartOutboundVoiceContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartOutboundVoiceContactResponse =
      zio.aws.connect.model
        .StartOutboundVoiceContactResponse(contactId.map(value => value))
    def contactId: Optional[ContactId]
    def getContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("contactId", contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse
  ) extends zio.aws.connect.model.StartOutboundVoiceContactResponse.ReadOnly {
    override val contactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse
  ): zio.aws.connect.model.StartOutboundVoiceContactResponse.ReadOnly =
    new Wrapper(impl)
}
