package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait Statistic {
  def unwrap: software.amazon.awssdk.services.connect.model.Statistic
}
object Statistic {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.Statistic
  ): zio.aws.connect.model.Statistic = value match {
    case software.amazon.awssdk.services.connect.model.Statistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.Statistic.SUM =>
      val r = SUM
      r
    case software.amazon.awssdk.services.connect.model.Statistic.MAX =>
      val r = MAX
      r
    case software.amazon.awssdk.services.connect.model.Statistic.AVG =>
      val r = AVG
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Statistic =
      software.amazon.awssdk.services.connect.model.Statistic.UNKNOWN_TO_SDK_VERSION
  }
  case object SUM extends zio.aws.connect.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Statistic =
      software.amazon.awssdk.services.connect.model.Statistic.SUM
  }
  case object MAX extends zio.aws.connect.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Statistic =
      software.amazon.awssdk.services.connect.model.Statistic.MAX
  }
  case object AVG extends zio.aws.connect.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Statistic =
      software.amazon.awssdk.services.connect.model.Statistic.AVG
  }
}
