package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{StreamingId, ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class StopContactStreamingRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    streamingId: StreamingId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StopContactStreamingRequest = {
    import StopContactStreamingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StopContactStreamingRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .streamingId(StreamingId.unwrap(streamingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StopContactStreamingRequest.ReadOnly =
    zio.aws.connect.model.StopContactStreamingRequest.wrap(buildAwsValue())
}
object StopContactStreamingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StopContactStreamingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StopContactStreamingRequest =
      zio.aws.connect.model
        .StopContactStreamingRequest(instanceId, contactId, streamingId)
    def instanceId: InstanceId
    def contactId: ContactId
    def streamingId: StreamingId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getStreamingId: ZIO[Any, Nothing, StreamingId] =
      ZIO.succeed(streamingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StopContactStreamingRequest
  ) extends zio.aws.connect.model.StopContactStreamingRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val streamingId: StreamingId =
      zio.aws.connect.model.primitives.StreamingId(impl.streamingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StopContactStreamingRequest
  ): zio.aws.connect.model.StopContactStreamingRequest.ReadOnly = new Wrapper(
    impl
  )
}
