package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait StorageType {
  def unwrap: software.amazon.awssdk.services.connect.model.StorageType
}
object StorageType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.StorageType
  ): zio.aws.connect.model.StorageType = value match {
    case software.amazon.awssdk.services.connect.model.StorageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.StorageType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.connect.model.StorageType.KINESIS_VIDEO_STREAM =>
      val r = KINESIS_VIDEO_STREAM
      r
    case software.amazon.awssdk.services.connect.model.StorageType.KINESIS_STREAM =>
      val r = KINESIS_STREAM
      r
    case software.amazon.awssdk.services.connect.model.StorageType.KINESIS_FIREHOSE =>
      val r = KINESIS_FIREHOSE
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StorageType =
      software.amazon.awssdk.services.connect.model.StorageType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.connect.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StorageType =
      software.amazon.awssdk.services.connect.model.StorageType.S3
  }
  case object KINESIS_VIDEO_STREAM extends zio.aws.connect.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StorageType =
      software.amazon.awssdk.services.connect.model.StorageType.KINESIS_VIDEO_STREAM
  }
  case object KINESIS_STREAM extends zio.aws.connect.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StorageType =
      software.amazon.awssdk.services.connect.model.StorageType.KINESIS_STREAM
  }
  case object KINESIS_FIREHOSE extends zio.aws.connect.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StorageType =
      software.amazon.awssdk.services.connect.model.StorageType.KINESIS_FIREHOSE
  }
}
