package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait StringComparisonType {
  def unwrap: software.amazon.awssdk.services.connect.model.StringComparisonType
}
object StringComparisonType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.StringComparisonType
  ): zio.aws.connect.model.StringComparisonType = value match {
    case software.amazon.awssdk.services.connect.model.StringComparisonType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.StringComparisonType.STARTS_WITH =>
      val r = STARTS_WITH
      r
    case software.amazon.awssdk.services.connect.model.StringComparisonType.CONTAINS =>
      val r = CONTAINS
      r
    case software.amazon.awssdk.services.connect.model.StringComparisonType.EXACT =>
      val r = EXACT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.StringComparisonType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StringComparisonType =
      software.amazon.awssdk.services.connect.model.StringComparisonType.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTS_WITH extends zio.aws.connect.model.StringComparisonType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StringComparisonType =
      software.amazon.awssdk.services.connect.model.StringComparisonType.STARTS_WITH
  }
  case object CONTAINS extends zio.aws.connect.model.StringComparisonType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StringComparisonType =
      software.amazon.awssdk.services.connect.model.StringComparisonType.CONTAINS
  }
  case object EXACT extends zio.aws.connect.model.StringComparisonType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.StringComparisonType =
      software.amazon.awssdk.services.connect.model.StringComparisonType.EXACT
  }
}
