package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ResourceId, InstanceId}
import scala.jdk.CollectionConverters._
final case class SubmitContactEvaluationRequest(
    instanceId: InstanceId,
    evaluationId: ResourceId,
    answers: Optional[
      Map[ResourceId, zio.aws.connect.model.EvaluationAnswerInput]
    ] = Optional.Absent,
    notes: Optional[Map[ResourceId, zio.aws.connect.model.EvaluationNote]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SubmitContactEvaluationRequest = {
    import SubmitContactEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SubmitContactEvaluationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .evaluationId(ResourceId.unwrap(evaluationId): java.lang.String)
      .optionallyWith(
        answers.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceId.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.answers)
      .optionallyWith(
        notes.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceId.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.notes)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SubmitContactEvaluationRequest.ReadOnly =
    zio.aws.connect.model.SubmitContactEvaluationRequest.wrap(buildAwsValue())
}
object SubmitContactEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SubmitContactEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SubmitContactEvaluationRequest =
      zio.aws.connect.model.SubmitContactEvaluationRequest(
        instanceId,
        evaluationId,
        answers.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        notes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def instanceId: InstanceId
    def evaluationId: ResourceId
    def answers: Optional[
      Map[ResourceId, zio.aws.connect.model.EvaluationAnswerInput.ReadOnly]
    ]
    def notes: Optional[
      Map[ResourceId, zio.aws.connect.model.EvaluationNote.ReadOnly]
    ]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getEvaluationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationId)
    def getAnswers: ZIO[Any, AwsError, Map[
      ResourceId,
      zio.aws.connect.model.EvaluationAnswerInput.ReadOnly
    ]] = AwsError.unwrapOptionField("answers", answers)
    def getNotes: ZIO[Any, AwsError, Map[
      ResourceId,
      zio.aws.connect.model.EvaluationNote.ReadOnly
    ]] = AwsError.unwrapOptionField("notes", notes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SubmitContactEvaluationRequest
  ) extends zio.aws.connect.model.SubmitContactEvaluationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val evaluationId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationId())
    override val answers: Optional[
      Map[ResourceId, zio.aws.connect.model.EvaluationAnswerInput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.answers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives.ResourceId(
              key
            ) -> zio.aws.connect.model.EvaluationAnswerInput.wrap(value)
          })
          .toMap
      )
    override val notes: Optional[
      Map[ResourceId, zio.aws.connect.model.EvaluationNote.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives.ResourceId(
              key
            ) -> zio.aws.connect.model.EvaluationNote.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SubmitContactEvaluationRequest
  ): zio.aws.connect.model.SubmitContactEvaluationRequest.ReadOnly =
    new Wrapper(impl)
}
