package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ARN, ResourceId}
import scala.jdk.CollectionConverters._
final case class SubmitContactEvaluationResponse(
    evaluationId: ResourceId,
    evaluationArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SubmitContactEvaluationResponse = {
    import SubmitContactEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SubmitContactEvaluationResponse
      .builder()
      .evaluationId(ResourceId.unwrap(evaluationId): java.lang.String)
      .evaluationArn(ARN.unwrap(evaluationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.SubmitContactEvaluationResponse.ReadOnly =
    zio.aws.connect.model.SubmitContactEvaluationResponse.wrap(buildAwsValue())
}
object SubmitContactEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SubmitContactEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SubmitContactEvaluationResponse =
      zio.aws.connect.model
        .SubmitContactEvaluationResponse(evaluationId, evaluationArn)
    def evaluationId: ResourceId
    def evaluationArn: ARN
    def getEvaluationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationId)
    def getEvaluationArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(evaluationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SubmitContactEvaluationResponse
  ) extends zio.aws.connect.model.SubmitContactEvaluationResponse.ReadOnly {
    override val evaluationId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationId())
    override val evaluationArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SubmitContactEvaluationResponse
  ): zio.aws.connect.model.SubmitContactEvaluationResponse.ReadOnly =
    new Wrapper(impl)
}
