package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TagCondition(
    tagKey: Optional[String] = Optional.Absent,
    tagValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TagCondition = {
    import TagCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TagCondition
      .builder()
      .optionallyWith(tagKey.map(value => value: java.lang.String))(_.tagKey)
      .optionallyWith(tagValue.map(value => value: java.lang.String))(
        _.tagValue
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TagCondition.ReadOnly =
    zio.aws.connect.model.TagCondition.wrap(buildAwsValue())
}
object TagCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TagCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TagCondition = zio.aws.connect.model
      .TagCondition(tagKey.map(value => value), tagValue.map(value => value))
    def tagKey: Optional[String]
    def tagValue: Optional[String]
    def getTagKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tagKey", tagKey)
    def getTagValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tagValue", tagValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TagCondition
  ) extends zio.aws.connect.model.TagCondition.ReadOnly {
    override val tagKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tagKey())
      .map(value => value: String)
    override val tagValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TagCondition
  ): zio.aws.connect.model.TagCondition.ReadOnly = new Wrapper(impl)
}
