package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{TagValueString, TagKeyString}
import scala.jdk.CollectionConverters._
final case class TagSearchCondition(
    tagKey: Optional[TagKeyString] = Optional.Absent,
    tagValue: Optional[TagValueString] = Optional.Absent,
    tagKeyComparisonType: Optional[zio.aws.connect.model.StringComparisonType] =
      Optional.Absent,
    tagValueComparisonType: Optional[
      zio.aws.connect.model.StringComparisonType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TagSearchCondition = {
    import TagSearchCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TagSearchCondition
      .builder()
      .optionallyWith(
        tagKey.map(value => TagKeyString.unwrap(value): java.lang.String)
      )(_.tagKey)
      .optionallyWith(
        tagValue.map(value => TagValueString.unwrap(value): java.lang.String)
      )(_.tagValue)
      .optionallyWith(tagKeyComparisonType.map(value => value.unwrap))(
        _.tagKeyComparisonType
      )
      .optionallyWith(tagValueComparisonType.map(value => value.unwrap))(
        _.tagValueComparisonType
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TagSearchCondition.ReadOnly =
    zio.aws.connect.model.TagSearchCondition.wrap(buildAwsValue())
}
object TagSearchCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TagSearchCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TagSearchCondition =
      zio.aws.connect.model.TagSearchCondition(
        tagKey.map(value => value),
        tagValue.map(value => value),
        tagKeyComparisonType.map(value => value),
        tagValueComparisonType.map(value => value)
      )
    def tagKey: Optional[TagKeyString]
    def tagValue: Optional[TagValueString]
    def tagKeyComparisonType
        : Optional[zio.aws.connect.model.StringComparisonType]
    def tagValueComparisonType
        : Optional[zio.aws.connect.model.StringComparisonType]
    def getTagKey: ZIO[Any, AwsError, TagKeyString] =
      AwsError.unwrapOptionField("tagKey", tagKey)
    def getTagValue: ZIO[Any, AwsError, TagValueString] =
      AwsError.unwrapOptionField("tagValue", tagValue)
    def getTagKeyComparisonType
        : ZIO[Any, AwsError, zio.aws.connect.model.StringComparisonType] =
      AwsError.unwrapOptionField("tagKeyComparisonType", tagKeyComparisonType)
    def getTagValueComparisonType
        : ZIO[Any, AwsError, zio.aws.connect.model.StringComparisonType] =
      AwsError.unwrapOptionField(
        "tagValueComparisonType",
        tagValueComparisonType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TagSearchCondition
  ) extends zio.aws.connect.model.TagSearchCondition.ReadOnly {
    override val tagKey: Optional[TagKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.tagKey())
      .map(value => zio.aws.connect.model.primitives.TagKeyString(value))
    override val tagValue: Optional[TagValueString] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValue())
      .map(value => zio.aws.connect.model.primitives.TagValueString(value))
    override val tagKeyComparisonType
        : Optional[zio.aws.connect.model.StringComparisonType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagKeyComparisonType())
        .map(value => zio.aws.connect.model.StringComparisonType.wrap(value))
    override val tagValueComparisonType
        : Optional[zio.aws.connect.model.StringComparisonType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagValueComparisonType())
        .map(value => zio.aws.connect.model.StringComparisonType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TagSearchCondition
  ): zio.aws.connect.model.TagSearchCondition.ReadOnly = new Wrapper(impl)
}
