package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class TagSet(
    key: Optional[TagKey] = Optional.Absent,
    value: Optional[TagValue] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.TagSet = {
    import TagSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TagSet
      .builder()
      .optionallyWith(key.map(value => TagKey.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TagSet.ReadOnly =
    zio.aws.connect.model.TagSet.wrap(buildAwsValue())
}
object TagSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.TagSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TagSet = zio.aws.connect.model
      .TagSet(key.map(value => value), value.map(value => value))
    def key: Optional[TagKey]
    def value: Optional[TagValue]
    def getKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TagSet
  ) extends zio.aws.connect.model.TagSet.ReadOnly {
    override val key: Optional[TagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.connect.model.primitives.TagKey(value))
    override val value: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.connect.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TagSet
  ): zio.aws.connect.model.TagSet.ReadOnly = new Wrapper(impl)
}
