package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ReferenceKey,
  ContactFlowId,
  TaskDescriptionExpression,
  TaskNameExpression
}
import scala.jdk.CollectionConverters._
final case class TaskActionDefinition(
    name: TaskNameExpression,
    description: Optional[TaskDescriptionExpression] = Optional.Absent,
    contactFlowId: ContactFlowId,
    references: Optional[Map[ReferenceKey, zio.aws.connect.model.Reference]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TaskActionDefinition = {
    import TaskActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TaskActionDefinition
      .builder()
      .name(TaskNameExpression.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          TaskDescriptionExpression.unwrap(value): java.lang.String
        )
      )(_.description)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .optionallyWith(
        references.map(value =>
          value
            .map({ case (key, value) =>
              (ReferenceKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.references)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TaskActionDefinition.ReadOnly =
    zio.aws.connect.model.TaskActionDefinition.wrap(buildAwsValue())
}
object TaskActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TaskActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TaskActionDefinition =
      zio.aws.connect.model.TaskActionDefinition(
        name,
        description.map(value => value),
        contactFlowId,
        references.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def name: TaskNameExpression
    def description: Optional[TaskDescriptionExpression]
    def contactFlowId: ContactFlowId
    def references
        : Optional[Map[ReferenceKey, zio.aws.connect.model.Reference.ReadOnly]]
    def getName: ZIO[Any, Nothing, TaskNameExpression] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, TaskDescriptionExpression] =
      AwsError.unwrapOptionField("description", description)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
    def getReferences: ZIO[Any, AwsError, Map[
      ReferenceKey,
      zio.aws.connect.model.Reference.ReadOnly
    ]] = AwsError.unwrapOptionField("references", references)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TaskActionDefinition
  ) extends zio.aws.connect.model.TaskActionDefinition.ReadOnly {
    override val name: TaskNameExpression =
      zio.aws.connect.model.primitives.TaskNameExpression(impl.name())
    override val description: Optional[TaskDescriptionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.TaskDescriptionExpression(value)
        )
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
    override val references: Optional[
      Map[ReferenceKey, zio.aws.connect.model.Reference.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.references())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .ReferenceKey(key) -> zio.aws.connect.model.Reference.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TaskActionDefinition
  ): zio.aws.connect.model.TaskActionDefinition.ReadOnly = new Wrapper(impl)
}
