package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TaskTemplateSingleSelectOption,
  TaskTemplateFieldDescription
}
import scala.jdk.CollectionConverters._
final case class TaskTemplateField(
    id: zio.aws.connect.model.TaskTemplateFieldIdentifier,
    description: Optional[TaskTemplateFieldDescription] = Optional.Absent,
    `type`: Optional[zio.aws.connect.model.TaskTemplateFieldType] =
      Optional.Absent,
    singleSelectOptions: Optional[Iterable[TaskTemplateSingleSelectOption]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TaskTemplateField = {
    import TaskTemplateField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TaskTemplateField
      .builder()
      .id(id.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          TaskTemplateFieldDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        singleSelectOptions.map(value =>
          value.map { item =>
            TaskTemplateSingleSelectOption.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.singleSelectOptions)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TaskTemplateField.ReadOnly =
    zio.aws.connect.model.TaskTemplateField.wrap(buildAwsValue())
}
object TaskTemplateField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TaskTemplateField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TaskTemplateField =
      zio.aws.connect.model.TaskTemplateField(
        id.asEditable,
        description.map(value => value),
        `type`.map(value => value),
        singleSelectOptions.map(value => value)
      )
    def id: zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly
    def description: Optional[TaskTemplateFieldDescription]
    def `type`: Optional[zio.aws.connect.model.TaskTemplateFieldType]
    def singleSelectOptions: Optional[List[TaskTemplateSingleSelectOption]]
    def getId: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly
    ] = ZIO.succeed(id)
    def getDescription: ZIO[Any, AwsError, TaskTemplateFieldDescription] =
      AwsError.unwrapOptionField("description", description)
    def getType
        : ZIO[Any, AwsError, zio.aws.connect.model.TaskTemplateFieldType] =
      AwsError.unwrapOptionField("type", `type`)
    def getSingleSelectOptions
        : ZIO[Any, AwsError, List[TaskTemplateSingleSelectOption]] =
      AwsError.unwrapOptionField("singleSelectOptions", singleSelectOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateField
  ) extends zio.aws.connect.model.TaskTemplateField.ReadOnly {
    override val id
        : zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly =
      zio.aws.connect.model.TaskTemplateFieldIdentifier.wrap(impl.id())
    override val description: Optional[TaskTemplateFieldDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.TaskTemplateFieldDescription(value)
        )
    override val `type`: Optional[zio.aws.connect.model.TaskTemplateFieldType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.connect.model.TaskTemplateFieldType.wrap(value))
    override val singleSelectOptions
        : Optional[List[TaskTemplateSingleSelectOption]] = zio.aws.core.internal
      .optionalFromNullable(impl.singleSelectOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.TaskTemplateSingleSelectOption(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateField
  ): zio.aws.connect.model.TaskTemplateField.ReadOnly = new Wrapper(impl)
}
