package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.TaskTemplateFieldName
import scala.jdk.CollectionConverters._
final case class TaskTemplateFieldIdentifier(
    name: Optional[TaskTemplateFieldName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TaskTemplateFieldIdentifier = {
    import TaskTemplateFieldIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TaskTemplateFieldIdentifier
      .builder()
      .optionallyWith(
        name.map(value => TaskTemplateFieldName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly =
    zio.aws.connect.model.TaskTemplateFieldIdentifier.wrap(buildAwsValue())
}
object TaskTemplateFieldIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TaskTemplateFieldIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TaskTemplateFieldIdentifier =
      zio.aws.connect.model
        .TaskTemplateFieldIdentifier(name.map(value => value))
    def name: Optional[TaskTemplateFieldName]
    def getName: ZIO[Any, AwsError, TaskTemplateFieldName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateFieldIdentifier
  ) extends zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly {
    override val name: Optional[TaskTemplateFieldName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.connect.model.primitives.TaskTemplateFieldName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateFieldIdentifier
  ): zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
