package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  TaskTemplateArn,
  TaskTemplateDescription,
  Timestamp,
  TaskTemplateId,
  TaskTemplateName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TaskTemplateMetadata(
    id: Optional[TaskTemplateId] = Optional.Absent,
    arn: Optional[TaskTemplateArn] = Optional.Absent,
    name: Optional[TaskTemplateName] = Optional.Absent,
    description: Optional[TaskTemplateDescription] = Optional.Absent,
    status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TaskTemplateMetadata = {
    import TaskTemplateMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TaskTemplateMetadata
      .builder()
      .optionallyWith(
        id.map(value => TaskTemplateId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => TaskTemplateArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => TaskTemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          TaskTemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TaskTemplateMetadata.ReadOnly =
    zio.aws.connect.model.TaskTemplateMetadata.wrap(buildAwsValue())
}
object TaskTemplateMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TaskTemplateMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TaskTemplateMetadata =
      zio.aws.connect.model.TaskTemplateMetadata(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        lastModifiedTime.map(value => value),
        createdTime.map(value => value)
      )
    def id: Optional[TaskTemplateId]
    def arn: Optional[TaskTemplateArn]
    def name: Optional[TaskTemplateName]
    def description: Optional[TaskTemplateDescription]
    def status: Optional[zio.aws.connect.model.TaskTemplateStatus]
    def lastModifiedTime: Optional[Timestamp]
    def createdTime: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, TaskTemplateId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, TaskTemplateArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, TaskTemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, TaskTemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.TaskTemplateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateMetadata
  ) extends zio.aws.connect.model.TaskTemplateMetadata.ReadOnly {
    override val id: Optional[TaskTemplateId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.TaskTemplateId(value))
    override val arn: Optional[TaskTemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.TaskTemplateArn(value))
    override val name: Optional[TaskTemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.TaskTemplateName(value))
    override val description: Optional[TaskTemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.TaskTemplateDescription(value)
        )
    override val status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.TaskTemplateStatus.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateMetadata
  ): zio.aws.connect.model.TaskTemplateMetadata.ReadOnly = new Wrapper(impl)
}
