package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TelephonyConfig(
    distributions: Iterable[zio.aws.connect.model.Distribution]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TelephonyConfig = {
    import TelephonyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TelephonyConfig
      .builder()
      .distributions(distributions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TelephonyConfig.ReadOnly =
    zio.aws.connect.model.TelephonyConfig.wrap(buildAwsValue())
}
object TelephonyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TelephonyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TelephonyConfig =
      zio.aws.connect.model.TelephonyConfig(distributions.map { item =>
        item.asEditable
      })
    def distributions: List[zio.aws.connect.model.Distribution.ReadOnly]
    def getDistributions
        : ZIO[Any, Nothing, List[zio.aws.connect.model.Distribution.ReadOnly]] =
      ZIO.succeed(distributions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TelephonyConfig
  ) extends zio.aws.connect.model.TelephonyConfig.ReadOnly {
    override val distributions
        : List[zio.aws.connect.model.Distribution.ReadOnly] = impl
      .distributions()
      .asScala
      .map { item =>
        zio.aws.connect.model.Distribution.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TelephonyConfig
  ): zio.aws.connect.model.TelephonyConfig.ReadOnly = new Wrapper(impl)
}
