package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ThresholdValue, ResourceArnOrId}
import scala.jdk.CollectionConverters._
final case class ThresholdV2(
    comparison: Optional[ResourceArnOrId] = Optional.Absent,
    thresholdValue: Optional[ThresholdValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ThresholdV2 = {
    import ThresholdV2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ThresholdV2
      .builder()
      .optionallyWith(
        comparison.map(value => ResourceArnOrId.unwrap(value): java.lang.String)
      )(_.comparison)
      .optionallyWith(
        thresholdValue.map(value =>
          ThresholdValue.unwrap(value): java.lang.Double
        )
      )(_.thresholdValue)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ThresholdV2.ReadOnly =
    zio.aws.connect.model.ThresholdV2.wrap(buildAwsValue())
}
object ThresholdV2 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ThresholdV2
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ThresholdV2 =
      zio.aws.connect.model.ThresholdV2(
        comparison.map(value => value),
        thresholdValue.map(value => value)
      )
    def comparison: Optional[ResourceArnOrId]
    def thresholdValue: Optional[ThresholdValue]
    def getComparison: ZIO[Any, AwsError, ResourceArnOrId] =
      AwsError.unwrapOptionField("comparison", comparison)
    def getThresholdValue: ZIO[Any, AwsError, ThresholdValue] =
      AwsError.unwrapOptionField("thresholdValue", thresholdValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ThresholdV2
  ) extends zio.aws.connect.model.ThresholdV2.ReadOnly {
    override val comparison: Optional[ResourceArnOrId] = zio.aws.core.internal
      .optionalFromNullable(impl.comparison())
      .map(value => zio.aws.connect.model.primitives.ResourceArnOrId(value))
    override val thresholdValue: Optional[ThresholdValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thresholdValue())
        .map(value => zio.aws.connect.model.primitives.ThresholdValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ThresholdV2
  ): zio.aws.connect.model.ThresholdV2.ReadOnly = new Wrapper(impl)
}
