package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  InstanceArn,
  Name128,
  TagValue,
  TrafficDistributionGroupId,
  TrafficDistributionGroupArn,
  Description250,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class TrafficDistributionGroup(
    id: Optional[TrafficDistributionGroupId] = Optional.Absent,
    arn: Optional[TrafficDistributionGroupArn] = Optional.Absent,
    name: Optional[Name128] = Optional.Absent,
    description: Optional[Description250] = Optional.Absent,
    instanceArn: Optional[InstanceArn] = Optional.Absent,
    status: Optional[zio.aws.connect.model.TrafficDistributionGroupStatus] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TrafficDistributionGroup = {
    import TrafficDistributionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TrafficDistributionGroup
      .builder()
      .optionallyWith(
        id.map(value =>
          TrafficDistributionGroupId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        arn.map(value =>
          TrafficDistributionGroupArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        name.map(value => Name128.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description250.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        instanceArn.map(value => InstanceArn.unwrap(value): java.lang.String)
      )(_.instanceArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TrafficDistributionGroup.ReadOnly =
    zio.aws.connect.model.TrafficDistributionGroup.wrap(buildAwsValue())
}
object TrafficDistributionGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TrafficDistributionGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TrafficDistributionGroup =
      zio.aws.connect.model.TrafficDistributionGroup(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        instanceArn.map(value => value),
        status.map(value => value),
        tags.map(value => value),
        isDefault.map(value => value)
      )
    def id: Optional[TrafficDistributionGroupId]
    def arn: Optional[TrafficDistributionGroupArn]
    def name: Optional[Name128]
    def description: Optional[Description250]
    def instanceArn: Optional[InstanceArn]
    def status: Optional[zio.aws.connect.model.TrafficDistributionGroupStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def isDefault: Optional[Boolean]
    def getId: ZIO[Any, AwsError, TrafficDistributionGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, TrafficDistributionGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name128] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description250] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceArn: ZIO[Any, AwsError, InstanceArn] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TrafficDistributionGroupStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TrafficDistributionGroup
  ) extends zio.aws.connect.model.TrafficDistributionGroup.ReadOnly {
    override val id: Optional[TrafficDistributionGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.connect.model.primitives.TrafficDistributionGroupId(value)
        )
    override val arn: Optional[TrafficDistributionGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.connect.model.primitives.TrafficDistributionGroupArn(value)
        )
    override val name: Optional[Name128] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.Name128(value))
    override val description: Optional[Description250] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.Description250(value))
    override val instanceArn: Optional[InstanceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceArn())
      .map(value => zio.aws.connect.model.primitives.InstanceArn(value))
    override val status
        : Optional[zio.aws.connect.model.TrafficDistributionGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.connect.model.TrafficDistributionGroupStatus.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TrafficDistributionGroup
  ): zio.aws.connect.model.TrafficDistributionGroup.ReadOnly = new Wrapper(impl)
}
