package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.UserId
import scala.jdk.CollectionConverters._
final case class TrafficDistributionGroupUserSummary(
    userId: Optional[UserId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary = {
    import TrafficDistributionGroupUserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.TrafficDistributionGroupUserSummary.ReadOnly =
    zio.aws.connect.model.TrafficDistributionGroupUserSummary
      .wrap(buildAwsValue())
}
object TrafficDistributionGroupUserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TrafficDistributionGroupUserSummary =
      zio.aws.connect.model
        .TrafficDistributionGroupUserSummary(userId.map(value => value))
    def userId: Optional[UserId]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary
  ) extends zio.aws.connect.model.TrafficDistributionGroupUserSummary.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.connect.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary
  ): zio.aws.connect.model.TrafficDistributionGroupUserSummary.ReadOnly =
    new Wrapper(impl)
}
