package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait Unit {
  def unwrap: software.amazon.awssdk.services.connect.model.Unit
}
object Unit {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.Unit
  ): zio.aws.connect.model.Unit = value match {
    case software.amazon.awssdk.services.connect.model.Unit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.Unit.SECONDS =>
      val r = SECONDS
      r
    case software.amazon.awssdk.services.connect.model.Unit.COUNT =>
      val r = COUNT
      r
    case software.amazon.awssdk.services.connect.model.Unit.PERCENT =>
      val r = PERCENT
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.Unit {
    override def unwrap: software.amazon.awssdk.services.connect.model.Unit =
      software.amazon.awssdk.services.connect.model.Unit.UNKNOWN_TO_SDK_VERSION
  }
  case object SECONDS extends zio.aws.connect.model.Unit {
    override def unwrap: software.amazon.awssdk.services.connect.model.Unit =
      software.amazon.awssdk.services.connect.model.Unit.SECONDS
  }
  case object COUNT extends zio.aws.connect.model.Unit {
    override def unwrap: software.amazon.awssdk.services.connect.model.Unit =
      software.amazon.awssdk.services.connect.model.Unit.COUNT
  }
  case object PERCENT extends zio.aws.connect.model.Unit {
    override def unwrap: software.amazon.awssdk.services.connect.model.Unit =
      software.amazon.awssdk.services.connect.model.Unit.PERCENT
  }
}
