package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  AttributeValue,
  AttributeName,
  InstanceId,
  ContactId
}
import scala.jdk.CollectionConverters._
final case class UpdateContactAttributesRequest(
    initialContactId: ContactId,
    instanceId: InstanceId,
    attributes: Map[AttributeName, AttributeValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest = {
    import UpdateContactAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest
      .builder()
      .initialContactId(ContactId.unwrap(initialContactId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .attributes(
        attributes
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateContactAttributesRequest.ReadOnly =
    zio.aws.connect.model.UpdateContactAttributesRequest.wrap(buildAwsValue())
}
object UpdateContactAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateContactAttributesRequest =
      zio.aws.connect.model.UpdateContactAttributesRequest(
        initialContactId,
        instanceId,
        attributes
      )
    def initialContactId: ContactId
    def instanceId: InstanceId
    def attributes: Map[AttributeName, AttributeValue]
    def getInitialContactId: ZIO[Any, Nothing, ContactId] =
      ZIO.succeed(initialContactId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAttributes: ZIO[Any, Nothing, Map[AttributeName, AttributeValue]] =
      ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest
  ) extends zio.aws.connect.model.UpdateContactAttributesRequest.ReadOnly {
    override val initialContactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.initialContactId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val attributes: Map[AttributeName, AttributeValue] = impl
      .attributes()
      .asScala
      .map({ case (key, value) =>
        zio.aws.connect.model.primitives.AttributeName(
          key
        ) -> zio.aws.connect.model.primitives.AttributeValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest
  ): zio.aws.connect.model.UpdateContactAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
