package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ARN, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateContactEvaluationResponse(
    evaluationId: ResourceId,
    evaluationArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactEvaluationResponse = {
    import UpdateContactEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactEvaluationResponse
      .builder()
      .evaluationId(ResourceId.unwrap(evaluationId): java.lang.String)
      .evaluationArn(ARN.unwrap(evaluationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateContactEvaluationResponse.ReadOnly =
    zio.aws.connect.model.UpdateContactEvaluationResponse.wrap(buildAwsValue())
}
object UpdateContactEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateContactEvaluationResponse =
      zio.aws.connect.model
        .UpdateContactEvaluationResponse(evaluationId, evaluationArn)
    def evaluationId: ResourceId
    def evaluationArn: ARN
    def getEvaluationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationId)
    def getEvaluationArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(evaluationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactEvaluationResponse
  ) extends zio.aws.connect.model.UpdateContactEvaluationResponse.ReadOnly {
    override val evaluationId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationId())
    override val evaluationArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactEvaluationResponse
  ): zio.aws.connect.model.UpdateContactEvaluationResponse.ReadOnly =
    new Wrapper(impl)
}
