package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ContactFlowModuleDescription,
  ContactFlowModuleName,
  ContactFlowModuleId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateContactFlowModuleMetadataRequest(
    instanceId: InstanceId,
    contactFlowModuleId: ContactFlowModuleId,
    name: Optional[ContactFlowModuleName] = Optional.Absent,
    description: Optional[ContactFlowModuleDescription] = Optional.Absent,
    state: Optional[zio.aws.connect.model.ContactFlowModuleState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest = {
    import UpdateContactFlowModuleMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowModuleId(
        ContactFlowModuleId.unwrap(contactFlowModuleId): java.lang.String
      )
      .optionallyWith(
        name.map(value => ContactFlowModuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ContactFlowModuleDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateContactFlowModuleMetadataRequest.ReadOnly =
    zio.aws.connect.model.UpdateContactFlowModuleMetadataRequest
      .wrap(buildAwsValue())
}
object UpdateContactFlowModuleMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.UpdateContactFlowModuleMetadataRequest =
      zio.aws.connect.model.UpdateContactFlowModuleMetadataRequest(
        instanceId,
        contactFlowModuleId,
        name.map(value => value),
        description.map(value => value),
        state.map(value => value)
      )
    def instanceId: InstanceId
    def contactFlowModuleId: ContactFlowModuleId
    def name: Optional[ContactFlowModuleName]
    def description: Optional[ContactFlowModuleDescription]
    def state: Optional[zio.aws.connect.model.ContactFlowModuleState]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowModuleId: ZIO[Any, Nothing, ContactFlowModuleId] =
      ZIO.succeed(contactFlowModuleId)
    def getName: ZIO[Any, AwsError, ContactFlowModuleName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ContactFlowModuleDescription] =
      AwsError.unwrapOptionField("description", description)
    def getState
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowModuleState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest
  ) extends zio.aws.connect.model.UpdateContactFlowModuleMetadataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowModuleId: ContactFlowModuleId =
      zio.aws.connect.model.primitives
        .ContactFlowModuleId(impl.contactFlowModuleId())
    override val name: Optional[ContactFlowModuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowModuleName(value)
      )
    override val description: Optional[ContactFlowModuleDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.ContactFlowModuleDescription(value)
        )
    override val state: Optional[zio.aws.connect.model.ContactFlowModuleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.connect.model.ContactFlowModuleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest
  ): zio.aws.connect.model.UpdateContactFlowModuleMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
