package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ContactFlowDescription,
  ContactFlowName,
  ContactFlowId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateContactFlowNameRequest(
    instanceId: InstanceId,
    contactFlowId: ContactFlowId,
    name: Optional[ContactFlowName] = Optional.Absent,
    description: Optional[ContactFlowDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest = {
    import UpdateContactFlowNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .optionallyWith(
        name.map(value => ContactFlowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ContactFlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateContactFlowNameRequest.ReadOnly =
    zio.aws.connect.model.UpdateContactFlowNameRequest.wrap(buildAwsValue())
}
object UpdateContactFlowNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateContactFlowNameRequest =
      zio.aws.connect.model.UpdateContactFlowNameRequest(
        instanceId,
        contactFlowId,
        name.map(value => value),
        description.map(value => value)
      )
    def instanceId: InstanceId
    def contactFlowId: ContactFlowId
    def name: Optional[ContactFlowName]
    def description: Optional[ContactFlowDescription]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
    def getName: ZIO[Any, AwsError, ContactFlowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ContactFlowDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest
  ) extends zio.aws.connect.model.UpdateContactFlowNameRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
    override val name: Optional[ContactFlowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ContactFlowName(value))
    override val description: Optional[ContactFlowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.ContactFlowDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest
  ): zio.aws.connect.model.UpdateContactFlowNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
