package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  InstanceId,
  ReferenceKey,
  Description,
  ContactId,
  Name
}
import scala.jdk.CollectionConverters._
final case class UpdateContactRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    references: Optional[Map[ReferenceKey, zio.aws.connect.model.Reference]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactRequest = {
    import UpdateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        references.map(value =>
          value
            .map({ case (key, value) =>
              (ReferenceKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.references)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateContactRequest.ReadOnly =
    zio.aws.connect.model.UpdateContactRequest.wrap(buildAwsValue())
}
object UpdateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateContactRequest =
      zio.aws.connect.model.UpdateContactRequest(
        instanceId,
        contactId,
        name.map(value => value),
        description.map(value => value),
        references.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def name: Optional[Name]
    def description: Optional[Description]
    def references
        : Optional[Map[ReferenceKey, zio.aws.connect.model.Reference.ReadOnly]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getReferences: ZIO[Any, AwsError, Map[
      ReferenceKey,
      zio.aws.connect.model.Reference.ReadOnly
    ]] = AwsError.unwrapOptionField("references", references)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactRequest
  ) extends zio.aws.connect.model.UpdateContactRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.Description(value))
    override val references: Optional[
      Map[ReferenceKey, zio.aws.connect.model.Reference.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.references())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .ReferenceKey(key) -> zio.aws.connect.model.Reference.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactRequest
  ): zio.aws.connect.model.UpdateContactRequest.ReadOnly = new Wrapper(impl)
}
